/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.xml;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Provides dynamic (element/runtime dependent) bean type.
 *
 * @param <T> Must match {@link DomSpringBean} where @BeanType is used.
 * @see BeanType
 * @see BeanProviderRegistry
 */
public interface BeanTypeProvider<T extends DomSpringBean> {

  /**
   * Returns static bean type candidates when element is not available (e.g. for calculating quickfixes).
   *
   * @return Super class(es) of values returned by {@link #getBeanType(DomSpringBean)} or empty array if not determinable.
   */
  String @NotNull [] getBeanTypeCandidates();

  /**
   * Determines bean type for the given instance.
   *
   * @param t DomSpringBean instance.
   * @return Bean class or {@code null} if not determinable.
   */
  @Nullable
  String getBeanType(T t);
}
