/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.xml;

import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ConcurrentInstanceMap;
import org.jetbrains.annotations.ApiStatus;

import java.util.Map;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion = "2021.1")
public class BeanProviderRegistry {

  private static final BeanProviderRegistry INSTANCE = new BeanProviderRegistry();

  private final Map<Class<? extends BeanTypeProvider>, BeanTypeProvider> myBeanTypeProviderMap =
    ConcurrentInstanceMap.create();

  private final Map<Class<? extends BeanNameProvider>, BeanNameProvider> myBeanNameProviderMap =
    ConcurrentInstanceMap.create();

  public static BeanProviderRegistry getInstance() {
    return INSTANCE;
  }

  /**
   * @see SpringCommonUtils#getBeanTypeProvider(Class<? extends BeanTypeProvider>)
   */
  public BeanTypeProvider getBeanTypeProvider(Class<? extends BeanTypeProvider> provider) {
    return myBeanTypeProviderMap.get(provider);
  }

  /**
   * @see SpringCommonUtils#getBeanNameProvider(Class<? extends BeanNameProvider>)
   */
  public BeanNameProvider getBeanNameProvider(Class<? extends BeanNameProvider> provider) {
    return myBeanNameProviderMap.get(provider);
  }
}
