// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.values;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiType;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import org.jetbrains.annotations.Nullable;

/**
 * @author Yann C&eacute;bron
 */
public abstract class SpringValueConvertersRegistry extends GenericDomValueConvertersRegistry {

  public static GenericDomValueConvertersRegistry getInstance() {
    return ApplicationManager.getApplication().getService(SpringValueConvertersRegistry.class);
  }

  @SuppressWarnings("AbstractMethodCallInConstructor")
  protected SpringValueConvertersRegistry() {
    registerBuiltinValueConverters();
  }

  @Override
  protected @Nullable Converter<?> getCustomConverter(Pair<PsiType, GenericDomValue> pair) {
     for (SpringValueConvertersProvider provider : SpringValueConvertersProvider.EP.getExtensionList()) {
      final Condition<Pair<PsiType, GenericDomValue>> condition = provider.getCondition();
      if (condition.value(pair)) {
        return provider.getConverter();
      }
    }
    return null;
  }

  protected abstract void registerBuiltinValueConverters();
}
