// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.values;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiType;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;

public interface SpringValueConvertersProvider {
  ExtensionPointName<SpringValueConvertersProvider> EP = ExtensionPointName.create("com.intellij.spring.valueConverter");

  Converter getConverter();
  Condition<Pair<PsiType, GenericDomValue>> getCondition();
}
