/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.values;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * @author Yann C&eacute;bron
 */
public abstract class PlaceholderUtils {
  @NonNls
  public static final String PLACEHOLDER_CONFIGURER_CLASS = "org.springframework.beans.factory.config.PlaceholderConfigurerSupport";

  @NonNls public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
  @NonNls public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";

  @NonNls public static final String PLACEHOLDER_PREFIX_PROPERTY_NAME = "placeholderPrefix";
  @NonNls public static final String PLACEHOLDER_SUFFIX_PROPERTY_NAME = "placeholderSuffix";

  public static PlaceholderUtils getInstance() {
    return ApplicationManager.getApplication().getService(PlaceholderUtils.class);
  }

  public abstract Set<PropertiesFile> getResources(Collection<? extends SpringBeanPointer> configurerBeans);

  @NotNull
  public abstract Set<PropertiesFile> getPropertiesFile(Pair<String, PsiElement> location);

  public abstract List<Pair<String, PsiElement>> getLocations(CommonSpringBean configurerBean);

  public abstract boolean containsDefaultPlaceholderDefinitions(@NotNull GenericDomValue genericDomValue);

  public abstract boolean isRawTextPlaceholder(GenericDomValue genericDomValue);

  public abstract boolean isPlaceholder(GenericDomValue genericDomValue);

  public abstract boolean isPlaceholder(GenericDomValue genericDomValue, String stringValue);

  public abstract boolean isPlaceholder(String stringValue, List<SpringBeanPointer> configurers);

  public abstract boolean isDefaultPlaceholder(@Nullable String stringValue);

  public abstract Pair<String, String> getPlaceholderPrefixAndSuffix(DomSpringBean placeholderBean);

  @NotNull
  public abstract Pair<String, String> getPlaceholderPrefixAndSuffixInner(@Nullable SpringBeanPointer pointer);

  @NotNull
  public abstract Pair<String, String> getPlaceholderPrefixAndSuffixInner(DomSpringBean placeholderBean);

  public abstract PsiReference @NotNull [] createPlaceholderPropertiesReferences(GenericDomValue genericDomValue);

  public abstract PsiReference @NotNull [] createPlaceholderPropertiesReferences(PsiElement psiElement);

  @Nullable
  public abstract String resolvePlaceholders(@NotNull GenericDomValue genericDomValue);

  @NotNull
  public abstract Collection<String> getValueVariants(@NotNull SpringValueHolderDefinition property);

  @NotNull
  public abstract Collection<String> getValueVariants(GenericDomValue value);
}
