// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

package com.intellij.spring.model.values;

import com.intellij.psi.PsiType;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author Dmitry Avdeev
 */
public class ListOrSetValueConverter extends PropertyValueConverter {

  @Override
  @NotNull
  public List<PsiType> getValueTypes(final GenericDomValue element) {
    if (element instanceof SpringValue) {
      final List<PsiType> psiTypes = TypeHolderUtil.getRequiredTypes(((SpringValue)element));
      if (!psiTypes.isEmpty())
      return psiTypes;
    }
    final ListOrSet parent = (ListOrSet)element.getParent();
    assert parent != null;
    return parent.getRequiredTypes();
  }
}
