// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.xml.beans.SpringBean;
import org.jetbrains.annotations.Nullable;

public abstract class SpringConstructorArgUtils {

  public static SpringConstructorArgUtils getInstance() {
    return ApplicationManager.getApplication().getService(SpringConstructorArgUtils.class);
  }

  @Nullable
  public abstract PsiMethod getSpringBeanConstructor(@Nullable final SpringBean springBean, @Nullable final CommonSpringModel springModel) ;
}
