// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

public abstract class SpringBeanUtils {

  public static SpringBeanUtils getInstance() {
    return ApplicationManager.getApplication().getService(SpringBeanUtils.class);
  }

  public abstract CommonSpringBean findBean(@Nullable PomTarget target);

  public abstract CommonSpringBean findBean(@Nullable final PsiElement identifyingPsiElement);

  @Nullable
  public abstract SpringBeanPointer findBean(@NotNull final CommonSpringModel model, @NonNls @NotNull String beanName);

  @NotNull
  public abstract Set<String> findBeanNames(@NotNull final CommonSpringBean bean);

  public abstract boolean processChildBeans(@NotNull DomElement parent,
                                            final boolean includeParsedCustomBeanWrappers,
                                            @NotNull Processor<CommonSpringBean> processor);

  public abstract boolean processXmlFactoryBeans(@NotNull Project project,
                                                 @NotNull GlobalSearchScope scope,
                                                 @NotNull Processor<SpringBeanPointer> processor);
}
