// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.scope;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public abstract class SpringBeanScopeManager {

  public static SpringBeanScopeManager getInstance() {
    return ApplicationManager.getApplication().getService(SpringBeanScopeManager.class);
  }

  /**
   * Returns all <em>custom</em> bean scopes applicable in the current context.
   *
   * @param element Context.
   * @return Custom bean scopes.
   * @see SpringCustomBeanScope
   */
  public abstract List<SpringBeanScope> getCustomBeanScopes(@Nullable PsiElement element);
}
