/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.scope;

import com.intellij.ide.presentation.Presentation;
import org.jetbrains.annotations.NotNull;

@Presentation(icon = "JavaUltimateIcons.Jsf.Component")
public class SpringBeanScope {

  public static final SpringBeanScope SINGLETON_SCOPE = new SpringBeanScope("singleton");
  public static final SpringBeanScope PROTOTYPE_SCOPE = new SpringBeanScope("prototype");

  private static final SpringBeanScope[] ALL_DEFAULT_SCOPES = new SpringBeanScope[]{SINGLETON_SCOPE, PROTOTYPE_SCOPE};

  @NotNull
  private final String value;

  public SpringBeanScope(@NotNull String value) {
    this.value = value;
  }

  @NotNull
  public String getValue() {
    return value;
  }

  public static SpringBeanScope[] getDefaultScopes() {
    return ALL_DEFAULT_SCOPES;
  }
}