// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class IncludeAnnotationsFilter extends SpringContextFilter.IncludeClasses {

  public IncludeAnnotationsFilter(@NotNull Collection<PsiClass> classes) {
    super(classes);
  }

  @NotNull
  @Override
  public Set<SpringStereotypeElement> includeStereotypes(@NotNull Module module, @NotNull Set<PsiPackage> packages) {
    Set<SpringStereotypeElement>  includes = new LinkedHashSet<>();
    GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module);
    for (PsiClass psiClass : getClasses()) {
      final String qualifiedName = psiClass.getQualifiedName();
      if (qualifiedName != null) {
        includes.addAll(SpringContextIncludeAnnotationFilter.getAnnotatedStereotypes(psiClass, searchScope, packages));
      }
    }
    return includes;
  }
}
