// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam.utils;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;
import java.util.List;

/**
 * @author Yann C&eacute;bron
 */
public abstract class JamAnnotationTypeUtil {

  public static JamAnnotationTypeUtil getInstance(Module module) {
    return module.getService(JamAnnotationTypeUtil.class);
  }

  @NotNull
  public abstract List<PsiClass> getQualifierAnnotationTypesWithChildren();

  @NotNull
  public abstract List<String> getUserDefinedCustomComponentAnnotations();

  public abstract Collection<PsiClass> getAnnotationTypesWithChildren(@NotNull final String annotationName);

  public abstract Collection<PsiClass> getAnnotationTypesWithChildrenIncludingTests(@NotNull final String annotationName);
}
