// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam.testContexts.jdbc;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.semantic.SemKey;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public interface TestingSqlGroup extends JamElement {
  String VALUE_ATTR_NAME = "value";

  SemKey<JamAnnotationMeta> JAM_ANNOTATION_KEY = JamService.ANNO_META_KEY.subKey("TestingSqlGroup");
  SemKey<TestingSqlGroup> JAM_KEY = JamService.JAM_ELEMENT_KEY.subKey("TestingSqlGroup");
  SemKey<JamMemberMeta> META_KEY = JamService.getMetaKey(JAM_KEY);

  @NotNull
  List<SpringTestingSql> getSqlAnnotations();
}
