// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam.testContexts.jdbc;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.*;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class SpringTestingSqlGroup implements TestingSqlGroup {
  public static final SemKey<JamAnnotationMeta> JAM_ANNO_META_KEY = JAM_ANNOTATION_KEY.subKey("SpringTestingSqlGroup");
  private static final SemKey<SpringTestingSqlGroup> JAM_KEY = TestingSqlGroup.JAM_KEY.subKey("SpringTestingSqlGroup");

  public static final JamClassMeta<SpringTestingSqlGroup> CLASS_META = new JamClassMeta<>(null, SpringTestingSqlGroup.class, JAM_KEY);
  public static final JamMethodMeta<SpringTestingSqlGroup> METHOD_META = new JamMethodMeta<>(null, SpringTestingSqlGroup.class, JAM_KEY);

  public static final JamAnnotationAttributeMeta.Collection<SpringTestingSql> VALUE_ATTR_META =
    JamAttributeMeta.annoCollection(VALUE_ATTR_NAME, SpringTestingSql.ANNO_META, SpringTestingSql.class);

  public static final JamAnnotationArchetype ARCHETYPE = new JamAnnotationArchetype()
    .addAttribute(VALUE_ATTR_META);

  public static final JamAnnotationMeta ANNO_META =
    new JamAnnotationMeta(SpringAnnotationsConstants.TEST_SQL_GROUP, ARCHETYPE, JAM_ANNO_META_KEY);

  static {
    CLASS_META.addAnnotation(ANNO_META);
    METHOD_META.addAnnotation(ANNO_META);
  }

  private final PsiMember myPsiMember;
  private final PsiElementRef<PsiAnnotation> myPsiAnnotation;

  @SuppressWarnings("unused")
  public SpringTestingSqlGroup(@NotNull PsiMember psiMember) {
    myPsiMember = psiMember;
    myPsiAnnotation = ANNO_META.getAnnotationRef(psiMember);
  }

  @SuppressWarnings("unused")
  public SpringTestingSqlGroup(PsiAnnotation annotation) {
    myPsiMember = PsiTreeUtil.getParentOfType(annotation, PsiMember.class, true);
    myPsiAnnotation = PsiElementRef.real(annotation);
  }

  @NotNull
  public PsiMember getPsiElement() {
    return myPsiMember;
  }

  public boolean isPsiValid() {
    return myPsiMember.isValid();
  }

  @Nullable
  public PsiAnnotation getAnnotation() {
    return myPsiAnnotation.getPsiElement();
  }

  @NotNull
  @Override
  public List<SpringTestingSql> getSqlAnnotations() {
    return JamCommonUtil.getElementsIncludingSingle(getPsiElement(), ANNO_META, VALUE_ATTR_META);
  }
}
