// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam.testContexts;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;

public interface SpringTestingAnnotationsProvider {
  ExtensionPointName<SpringTestingAnnotationsProvider> EP_NAME = new ExtensionPointName<>("com.intellij.spring.testingAnnotationsProvider");

  @NotNull
  Collection<PsiClass>  getTestingAnnotations(@NotNull Module module);
}
