// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam.testContexts;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import org.jetbrains.annotations.NotNull;

import java.util.Set;

public abstract class SpringTestContextUtil {

  public static SpringTestContextUtil getInstance() {
    return ApplicationManager.getApplication().getService(SpringTestContextUtil.class);
  }

  public abstract boolean isTestContextConfigurationClass(@NotNull PsiClass psiClass);

  @NotNull
  public abstract CommonSpringModel getSpringTestingModel(@NotNull PsiClass testClass);

  public abstract void discoverConfigFiles(@NotNull ContextConfiguration contextConfiguration,
                                           @NotNull Set<XmlFile> appContexts,
                                           @NotNull Set<PsiClass> configurationContexts,
                                           PsiClass... contexts);
}
