/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlFile;
import com.intellij.semantic.SemKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Set;

public interface ContextConfiguration extends JamElement {
  String LOCATIONS_ATTR_NAME = "locations";
  String VALUE_ATTR_NAME = "value";
  String CLASSES_ATTR_NAME = "classes";
  String LOADER_ATTR_NAME = "loader";
  String[] XML_FILES_ATTRS = {LOCATIONS_ATTR_NAME, VALUE_ATTR_NAME};

  SemKey<JamAnnotationMeta> CONTEXT_CONFIGURATION_JAM_ANNOTATION_KEY = JamService.ANNO_META_KEY.subKey("ContextConfiguration");
  SemKey<ContextConfiguration> CONTEXT_CONFIGURATION_JAM_KEY = JamService.JAM_ELEMENT_KEY.subKey("ContextConfiguration");
  SemKey<JamMemberMeta> CONTEXT_CONFIGURATION_META_KEY = JamService.getMetaKey(CONTEXT_CONFIGURATION_JAM_KEY);

  @NotNull
  Set<XmlFile> getLocations(PsiClass @NotNull ... contexts);

  @NotNull
  List<PsiClass> getConfigurationClasses();

  @Nullable
  PsiClass getLoaderClass();

  boolean hasLocationsAttribute();

  boolean hasValueAttribute();

  PsiClass getPsiElement();

  @Nullable
  PsiAnnotation getAnnotation();

  @NotNull
  List<JamStringAttributeElement<List<XmlFile>>> getLocationElements();
}
