/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.semantic.SemKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Set;

public interface SpringPropertySource extends JamElement {
  String IGNORE_RESOURCE_NOT_FOUND_ATTR_NAME = "ignoreResourceNotFound";

  SemKey<SpringPropertySource> PROPERTY_SOURCE_JAM_KEY = JamService.JAM_ELEMENT_KEY.subKey("SpringPropertySource");
  SemKey<JamMemberMeta> PROPERTY_SOURCE_META_KEY = JamService.getMetaKey(PROPERTY_SOURCE_JAM_KEY);

  Set<PropertiesFile> getPropertiesFiles();

  PsiClass getPsiElement();

  boolean isPsiValid();

  @Nullable
  PsiAnnotation getAnnotation();

  @NotNull
  List<JamStringAttributeElement<Set<PropertiesFile>>> getLocationElements();

  boolean isIgnoreResourceNotFound();
}
