// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam.stereotype;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.semantic.SemKey;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import org.jetbrains.annotations.NotNull;

public class SpringJamComponentScan extends SpringJamComponentScanArchetype {

  private static final SemKey<SpringJamComponentScan> JAM_KEY = COMPONENT_SCAN_JAM_KEY.subKey("SpringJamComponentScan");
  public static final SemKey<SpringJamComponentScan> REPEATABLE_ANNO_JAM_KEY = JamService.JAM_ELEMENT_KEY.subKey("SpringJamComponentScan");

  public static final JamAnnotationMeta ANNOTATION_META =
    new JamAnnotationMeta(SpringAnnotationsConstants.COMPONENT_SCAN, ARCHETYPE, META_KEY);

  public static final JamClassMeta<SpringJamComponentScan> META =
    new JamClassMeta<>(null, SpringJamComponentScan.class, JAM_KEY).addAnnotation(ANNOTATION_META);

  public SpringJamComponentScan(@NotNull PsiClass psiElement) {
    super(psiElement);
  }

  public SpringJamComponentScan(PsiAnnotation annotation) {
    super(annotation);
  }

  @Override
  @NotNull
  protected JamAnnotationMeta getAnnotationMeta() {
    return ANNOTATION_META;
  }

}
