// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam.stereotype;

import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.psi.PsiClass;
import com.intellij.semantic.SemKey;
import org.jetbrains.annotations.NotNull;

public class CustomJamComponentScan extends CustomJamComponentScanBase {
  public static final SemKey<JamAnnotationMeta> JAM_ANNO_META_KEY = COMPONENT_SCAN_META_KEY.subKey("SpringJamComponentScan");

  public static final SemKey<CustomJamComponentScan> JAM_KEY = SpringComponentScan.COMPONENT_SCAN_JAM_KEY.subKey("CustomJamComponentScan");
  public static final SemKey<JamMemberMeta<PsiClass, CustomJamComponentScan>> META_KEY =
    SpringJamComponentScan.META.getMetaKey().subKey("CustomJamComponentScan");

  public CustomJamComponentScan(@NotNull String anno, @NotNull PsiClass psiClassAnchor) {
    super(anno, psiClassAnchor);
  }
}
