// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.jam;

import com.intellij.openapi.module.Module;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author Yann C&eacute;bron
 */
public abstract class SpringJamModel {

  public static SpringJamModel getModel(@NotNull Module module) {
    return module.getService(SpringJamModel.class);
  }

  @NotNull
  public abstract List<SpringStereotypeElement> getStereotypeComponents();

  @NotNull
  public abstract List<SpringStereotypeElement> getStereotypeComponents(@NotNull GlobalSearchScope scope);

  @NotNull
  public abstract List<SpringConfiguration> getConfigurations(@NotNull GlobalSearchScope scope);

  @NotNull
  public abstract List<SpringController> getControllers(@NotNull GlobalSearchScope scope);
}
