// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.

package com.intellij.spring.model.jam;

import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamPsiMethodSpringBean extends JamPsiMemberSpringBean<PsiMethod> {

  @Override
  @NotNull
  @JamPsiConnector
  public abstract PsiMethod getPsiElement();

  @Override
  @JamPsiValidity
  public abstract boolean isValid();

  @Override
  @Nullable
  public String getBeanName() {
    return getPsiElement().getName();
  }

  @Override
  @Nullable
  public PsiType getBeanType() {
    PsiMethod element = getPsiElement();
    return element.isValid()? element.getReturnType() : null;
  }

  /**
   * Returns actual {@code new MyImpl} type taken from method implementation if {@code considerFactories = true}.
   */
  @Nullable
  @Override
  public PsiType getBeanType(boolean considerFactories) {
    if (!considerFactories) {
      return getBeanType();
    }

    final PsiReturnStatement[] returnStatements = PsiUtil.findReturnStatements(getPsiElement());
    if (returnStatements.length == 1) {
      final PsiExpression returnValue = returnStatements[0].getReturnValue();

      if (returnValue != null) {
        return returnValue.getType();
      }
    }
    return getBeanType();
  }
}