// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.converters.fixes.bean;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiClassType;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.ConvertContext;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author Yann C&eacute;bron
 */
public abstract class SpringBeanResolveQuickFixManager {

  public static SpringBeanResolveQuickFixManager getInstance() {
    return ApplicationManager.getApplication().getService(SpringBeanResolveQuickFixManager.class);
  }

  public abstract LocalQuickFix[] getQuickFixes(ConvertContext context,
                                                @Nullable Beans beans,
                                                String beanId,
                                                List<PsiClassType> requiredClasses);
}
