/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.converters;

import com.intellij.psi.*;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * @author Yann C&eacute;bron
 */
public abstract class SpringImportResourceConverter extends Converter<Set<PsiFile>> implements CustomReferenceConverter {

  public static final NullableFunction<ResolveResult, XmlFile> XML_FILE_MAPPER = result -> {
    PsiElement psiElement = result.getElement();
    return psiElement instanceof XmlFile ? (XmlFile)psiElement : null;
  };

  public static List<XmlFile> getFiles(PsiReference[] references) {
    final Collection<XmlFile> items = SpringResourcesUtil.getInstance().getResourceItems(references, SpringDomUtils.SPRING_XML_CONDITION);
    return new ArrayList<>(items);
  }
}
