// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.actions.patterns.frameworks;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

/**
 * @author Yann C&eacute;bron
 */
public abstract class FrameworkSupportTemplatesRunner {

  public static FrameworkSupportTemplatesRunner getInstance() {
    return ApplicationManager.getApplication().getService(FrameworkSupportTemplatesRunner.class);
  }

  public abstract void generateSpringBeans(FrameworkSupportProvider provider,
                                           Module module,
                                           Editor editor,
                                           XmlFile xmlFile);

  @NotNull
  public abstract Map<String, String> getPredefinedVars(Module module,
                                                        XmlFile xmlFile);
}
