// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementAction;
import com.intellij.util.xml.ui.actions.generate.GenerateDomElementProvider;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;

@SuppressWarnings("ComponentNotRegistered")
public class GenerateSpringDomElementAction extends GenerateDomElementAction {

  public GenerateSpringDomElementAction(final GenerateDomElementProvider provider) {
    super(provider);
  }

  public GenerateSpringDomElementAction(final GenerateDomElementProvider provider, Icon icon) {
    super(provider);
    getTemplatePresentation().setIcon(icon);
  }

  @Override
  public boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
    return super.isValidForFile(project, editor, file) &&
           file instanceof XmlFile &&
           SpringDomUtils.isSpringXml((XmlFile)file) &&
           SpringManager.getInstance(project).getSpringModelByFile(file) != null;
  }
}