// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model;

import com.intellij.openapi.util.Comparing;
import gnu.trove.TObjectHashingStrategy;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

/**
 * @author Dmitry Avdeev
 */
public interface QualifierAttribute {

  @Nullable
  String getAttributeKey();

  @Nullable
  Object getAttributeValue();

  TObjectHashingStrategy<QualifierAttribute> HASHING_STRATEGY = new TObjectHashingStrategy<QualifierAttribute>() {

    @Override
    public int computeHashCode(final QualifierAttribute object) {
      final String key = object.getAttributeKey();
      final Object value = object.getAttributeValue();
      return (key == null ? 0 : key.hashCode()) + (value == null ? 0 : value.hashCode());
    }

    @Override
    public boolean equals(final QualifierAttribute o1, final QualifierAttribute o2) {
      return Objects.equals(o1.getAttributeKey(), o2.getAttributeKey()) && Comparing.equal(o1.getAttributeValue(), o2.getAttributeValue());
    }
  };
}
