/*
 * Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
 */
package com.intellij.spring.gutter.groups;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.psi.PsiElement;
import com.intellij.util.ConstantFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;
import java.util.Collection;
import java.util.List;

import static com.intellij.spring.gutter.groups.SpringGutterIconBuilder.DEFAULT_GUTTER_ICON_ALIGNMENT;

public class SpringGroupRelatedItemLineMarkerInfo extends RelatedItemLineMarkerInfo<PsiElement>  implements SpringGroupLineMarker{

  SpringGroupRelatedItemLineMarkerInfo(@NotNull PsiElement element,
                                       NavigationGutterIconRenderer renderer,
                                       @Nullable GutterIconNavigationHandler<PsiElement> navHandler,
                                       @NotNull NotNullFactory<? extends Collection<GotoRelatedItem>> targets) {
    super(element, element.getTextRange(), renderer.getIcon(),
          renderer.getTooltipText() == null ? null : new ConstantFunction<>(renderer.getTooltipText()),
          navHandler, DEFAULT_GUTTER_ICON_ALIGNMENT,
          targets);
  }

  @Override
  public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
    return info instanceof SpringGroupLineMarker;
  }

  @Override
  public Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
    return getSpringActionGroupIcon();
  }

  @Override
  public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
    return DEFAULT_GUTTER_ICON_ALIGNMENT;
  }

}
