// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.factories;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.CommonSpringBean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

public abstract class SpringFactoryBeansManager {

  public static final String FACTORY_BEAN_SUFFIX = "FactoryBean";

  public static SpringFactoryBeansManager getInstance() {
    return ApplicationManager.getApplication().getService(SpringFactoryBeansManager.class);
  }

  public abstract Set<PsiClass> getKnownBeanFactories(@NotNull final Project project);

  public abstract boolean isKnownBeanFactory(@Nullable final String factoryClass);

  public abstract boolean isFactoryBeanClass(@NotNull final PsiClass psiClass);

  public abstract boolean isValidFactoryMethod(@NotNull final PsiMethod psiMethod, final boolean isBeansXmlFactoryBean);

  /**
   * FactoryBean can produce PsiArrayType, primitive types, etc.
   */
  public abstract PsiType @NotNull [] getObjectTypes(@NotNull final PsiType factoryType, @Nullable final CommonSpringBean context);
}
