// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.facet;

import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.ide.projectWizard.ModuleTypeCategory;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.util.registry.Registry;
import icons.SpringApiIcons;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;

/**
 * @author Dmitry Avdeev
 */
public class SpringProjectCategory extends ModuleTypeCategory.Java {

  public static final String LEGACY_MODULE_BUILDER_ID = "LegacySpring";

  public static final FrameworkRole ROLE = new FrameworkRole(SpringFacet.FACET_TYPE_ID.toString());

  @Override
  public String getId() {
    return SpringFacet.FACET_TYPE_ID.toString();
  }

  @Override
  public String getDisplayName() {
    return "Spring (Legacy)";
  }

  @Override
  public Icon getIcon() {
    return SpringApiIcons.Spring;
  }

  @Override
  public String getDescription() {
    return null;
  }

  @Override
  public String @NotNull [] getPreselectedFrameworkIds() {
    return new String[] { FacetBasedFrameworkSupportProvider.getProviderId(SpringFacet.FACET_TYPE_ID) };
  }

  @Override
  public FrameworkRole[] getAcceptableFrameworkRoles() {
    return new FrameworkRole[] {ROLE};
  }

  @Override
  public @NotNull ModuleBuilder createModuleBuilder() {
    return new JavaModuleBuilder() {
      @Override
      public @NonNls @NotNull String getBuilderId() {
        return LEGACY_MODULE_BUILDER_ID;
      }

      @Override
      public boolean isAvailable() {
        return Registry.is("javaee.legacy.project.wizard", false);
      }
    };
  }
}
