// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.el.contextProviders;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * SpEL context variables completion/resolving.
 */
public abstract class SpringElContextsExtension {

  private static final ExtensionPointName<SpringElContextsExtension> EP_NAME =
    new ExtensionPointName<>("com.intellij.spring.el.contexts");

  public static List<SpringElContextsExtension> getProviders() {
    return EP_NAME.getExtensionList();
  }

  @NotNull
  public abstract Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement);

  /**
   * Returns a list of methods available on current "root" context.
   *
   * @param contextElement Context element.
   * @return Empty list by default or provided root methods.
   */
  @NotNull
  public Collection<PsiMethod> getRootMethods(@NotNull PsiElement contextElement) {
    return Collections.emptyList();
  }

  @Nullable
  public PsiVariable findContextVariable(@NotNull PsiElement contextElement, @NotNull final String hint) {
    return ContainerUtil.find(getContextVariables(contextElement), variable -> hint.equals(variable.getName()));
  }
}
