// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.dom;

import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;

/**
 * @see SpringCustomNamespaces
 */
public final class CustomNamespaceRegistrar {

  private final DomExtensionsRegistrar registrar;
  private final String namespaceKey;

  private CustomNamespaceRegistrar(DomExtensionsRegistrar registrar, String namespaceKey) {
    this.registrar = registrar;
    this.namespaceKey = namespaceKey;
  }

  public static CustomNamespaceRegistrar create(DomExtensionsRegistrar registrar, String namespaceKey) {
    return new CustomNamespaceRegistrar(registrar, namespaceKey);
  }

  public CustomNamespaceRegistrar add(final String xmlTagName, final Class<? extends DomElement> domElementClass) {
    registrar.registerCollectionChildrenExtension(new XmlName(xmlTagName, namespaceKey), domElementClass);
    return this;
  }

  public CustomNamespaceRegistrar addFixed(final String xmlTagName, final Class<? extends DomElement> domElementClass) {
    registrar.registerFixedNumberChildExtension(new XmlName(xmlTagName, namespaceKey), domElementClass);
    return this;
  }
}
