/*
 * Copyright 2000-2018 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.constants;

import org.jetbrains.annotations.NonNls;

public interface SpringCorePresentationConstants {
    @NonNls String CONFIGURATION = "@Configuration";
    @NonNls String CONTROLLER = "@Controller";
    @NonNls String SERVICE = "@Service";
    @NonNls String COMPONENT = "@Component";
    @NonNls String QUALIFIER = "@Qualifier";
    @NonNls String ACTIVE_PROFILES = "@ActiveProfiles";
    @NonNls String PROFILE = "@Profile";
    @NonNls String SPRING_BEAN = "Spring Bean";
    @NonNls String SPRING_PROPERTY = "Spring Property";
    @NonNls String SPRING_CONSTANT = "Spring Constant";
    @NonNls String SPRING_PROFILE = "Spring Profile";

}
