/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.spring;

import com.intellij.spring.facet.SpringAutodetectedFileSet;
import com.intellij.spring.facet.SpringFacet;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author Dmitry Avdeev
 */
public interface SpringModelProvider {
  /**
   * NOTE: Results *must* be cached as method is called many times from various places.
   *
   * @param facet Facet to get autodetected filesets for.
   * @return Filesets.
   * @see SpringAutodetectedFileSet
   */
  @NotNull
  List<? extends SpringAutodetectedFileSet> getFilesets(@NotNull SpringFacet facet);

  /**
   * Provides human-readable description of this provider.
   *
   * @return Class name.
   */
  default String getName() {
    return getClass().getSimpleName();
  }
}
