package com.intellij.sql.dialects;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author Liudmila Kornilova
 */

public interface EvaluationHelper {
  LanguageExtension<EvaluationHelper> EP = new LanguageExtension<>("com.intellij.sql.evaluationHelper", new DummyEvaluationHelper());

  Condition<PsiElement> isStatement();

  Condition<PsiElement> isFile();

  default Condition<PsiElement> canContainStatements() {
    return isFile();
  }

  SyntaxTraverser<PsiElement> statements(final TextRange range, final Language language, final SyntaxTraverser<PsiElement> s);

  JBIterable<PsiElement> parameters(final TextRange range, final Language language, final SyntaxTraverser<PsiElement> s);

  @NotNull
  SyntaxTraverser<PsiElement> parse(@NotNull Project project, @NotNull Language language, @NotNull CharSequence documentText, @Nullable Language hostLanguage);

  @NotNull
  default SyntaxTraverser<PsiElement> getNotebookTraverser(@NotNull SyntaxTraverser<PsiElement> traverser) {
    return traverser;
  }
}
