package com.intellij.sql.dialects;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyEvaluationHelper implements EvaluationHelper {

  @Override
  public Condition<PsiElement> isStatement() {
    return psiElement -> false;
  }

  @Override
  public Condition<PsiElement> canContainStatements() {
    return psiElement -> false;
  }

  @Override
  public Condition<PsiElement> isFile() {
    return psiElement -> false;
  }

  @Override
  public SyntaxTraverser<PsiElement> statements(final TextRange range, final Language language, final SyntaxTraverser<PsiElement> s) {
    return SyntaxTraverser.psiTraverser();
  }

  @Override
  public JBIterable<PsiElement> parameters(final TextRange range, final Language language, final SyntaxTraverser<PsiElement> s) {
    return JBIterable.empty();
  }

  @Override
  public @NotNull SyntaxTraverser<PsiElement> parse(@NotNull Project project,
                                                    @NotNull Language language,
                                                    @NotNull CharSequence documentText,
                                                    @Nullable Language hostLanguage) {
    return SyntaxTraverser.psiTraverser();
  }
}
