package com.intellij.jam.model.util

import com.intellij.jam.JamElement
import com.intellij.jam.JamService
import com.intellij.jam.reflect.JamMemberMeta
import com.intellij.psi.PsiMethod
import com.intellij.psi.PsiModifierListOwner
import com.intellij.semantic.SemKey

fun <T : JamElement> JamService.getJamElementForMethodOrSupers(
  psiMethod: PsiMethod,
  vararg metas: JamMemberMeta<out PsiModifierListOwner, out T>
): T? = JamCommonUtil.getJamElementForMethodOrSupers(this, psiMethod, *metas)

fun <T : JamElement> JamService.getJamElementForMethodOrSupers(
  key: SemKey<T>,
  psiMethod: PsiMethod
): T? = JamCommonUtil.getJamElementForMethodOrSupers(this, key, psiMethod)