package com.intellij.jam.model.util;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

import static com.intellij.util.containers.ContainerUtil.mapNotNull;
import static java.util.Collections.emptyList;
import static java.util.Collections.singleton;

public final class JamAnnotationUtil {
  private JamAnnotationUtil() {
  }

  private static final NullableFunction<PsiClass, String> PSI_CLASS_FQN = PsiClass::getQualifiedName;

  private static Collection<PsiClass> getAnnotationTypesWithChildrenIncludingTests(Module module, String annotationName) {
    if (module.isDisposed()) return emptyList();

    return MetaAnnotationUtil.getAnnotationTypesWithChildren(module, annotationName, true);
  }

  public static Collection<String> getChildAnnotations(@Nullable Module module, @NotNull String annotation) {
    if (module == null || module.isDisposed()) {
      return singleton(annotation);
    }
    Collection<PsiClass> classes = getAnnotationTypesWithChildrenIncludingTests(module, annotation);
    return mapNotNull(classes, PSI_CLASS_FQN);
  }
}
