package org.jetbrains.idea.tomcat.server;

import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServers.run.configuration.ServerModel;
import com.intellij.javaee.appServers.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.deployment.JspDeploymentManager;
import com.intellij.javaee.oss.server.JavaeeConfigurationType;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.TomcatPersistentDataWrapper;
import org.jetbrains.idea.tomcat.TomcatStartupPolicy;

public abstract class TomcatConfigurationBase extends JavaeeConfigurationType {
  public TomcatConfigurationBase(@NotNull String id) {
    super(id);
  }

  @Override
  @NotNull
  protected ServerModel createLocalModel() {
    return new TomcatLocalModel();
  }

  @Override
  @NotNull
  protected ServerModel createRemoteModel() {
    return new TomcatRemoteModel();
  }

  @Override
  @NotNull
  protected ExecutableObjectStartupPolicy createStartupPolicy() {
    return new TomcatStartupPolicy();
  }

  @Override
  public String getUrlToOpenInBrowser(@NotNull ApplicationServer server, @NotNull PsiFile psiFile) {
    final WebFacet webFacet = WebUtil.getWebFacet(psiFile);
    if (webFacet == null) return null;

    final int port = new TomcatPersistentDataWrapper(server).getSourceLocalPort();
    @NonNls final String root = "http://" + CommonModel.LOCALHOST + ":" + port;
    final String relativePath = JspDeploymentManager.getInstance().computeRelativeTargetPath(psiFile, webFacet);
    if (relativePath == null) return null;
    return DeploymentUtil.concatPaths(root, relativePath);
  }
}
