---- ListRoles ----
select
       roleid,
       trim(rolename) as rolename,
       remarks
from syscat.roles

---- ListSchemas ----
select
       trim(schemaname) as schemaname,
       remarks
from syscat.schemata

---- ListTables ----
select
       tabname,
       type,
       trim(base_tabschema) as base_tabschema,
       base_tabname,
       partition_mode,
       tableorg,
       clustered,
       pctfree,
       remarks
from syscat.tables
where tabschema = :schema_name

---- ListColumns ----
select
       c.tabname,
       c.colno,
       c.colname,
       trim(c.typeschema) as typeschema,
       c.typename,
       c.length,
       c.scale,
       c.codepage,
       c.default,
       c.nulls,
       c.identity,
       c.remarks,
       c.generated,
       c.text,
       c.inline_length,
       c.partkeyseq,
       cia.seqid
from syscat.columns c
    left join syscat.colidentattributes cia on c.tabschema = cia.tabschema and c.tabname = cia.tabname and c.colname = cia.colname
where c.tabschema = :schema_name
order by c.tabname

---- ListIndices ----
select
       ind.indname,
       trim(ind.indschema) as indschema,
       tabname,
       trim(tabschema) as tabschema,
       uniquerule,
       trim(indextype) as indextype,
       trim(viewname) as viewname,
       xml.typemodel,
       xml.hashed,
       trim(xml.datatype) as datatype,
       xml.length,
       xml.scale,
       xml.pattern,
       remarks
from syscat.indexes ind
    left outer join syscat.indexxmlpatterns xml on xml.indschema = ind.indschema and xml.indname = ind.indname
order by indname

---- ListIndexColumns ----
select
       indname,
       trim(indschema) as indschema,
       colname,
       colorder
from syscat.indexcoluse
order by indschema, indname, colseq

---- ListIndexExtensions ----
select
       trim(iename) as iename,
       remarks
from syscat.indexextensions
where ieschema = :schema_name

---- ListIndexExtensionSources ----
select
       iename,
       text
from syscat.indexextensions
where ieschema = :schema_name

---- ListIndexExtensionParameters ----
select
       trim(iename) as iename,
       ordinal,
       trim(parmname) as parmname,
       trim(typeschema) as typeschema,
       trim(typename) as typename,
       length,
       scale,
       codepage,
       parmtype
from syscat.indexextensionparms
where ieschema = :schema_name and parmtype = 'P'
order by iename, ordinal

---- ListIndexExtensionMethods ----
select
       trim(iename) as iename,
       methodid,
       trim(methodname) as methodname,
       remarks
from syscat.indexextensionmethods
where ieschema = :schema_name
order by iename

---- ListTableConstraints ----
select
       tabname,
       constname,
       type,
       remarks
from syscat.tabconst
where tabschema = :schema_name
order by tabname

---- ListKeyColumns ----
select
       trim(tabschema) || '.' || tabname || '.' || constname as fullkeyname,
       colname
from syscat.keycoluse
order by colseq

---- ListForeignKeys ----
select
       tabname,
       constname,
       trim(reftabschema) as reftabschema,
       reftabname,
       refkeyname,
       deleterule,
       updaterule
from syscat.references
where tabschema = :schema_name

---- ListChecks ----
select
       trim(constname) as constname,
       trim(tabname) as tabname,
       type,
       text
from syscat.checks
where tabschema = :schema_name and type = 'C' or type = 'O'
order by tabname, constname

---- ListTriggers ----
select
       trigname,
       trim(trigschema) as trigschema,
       tabname,
       granularity,
       trigtime,
       eventupdate,
       eventdelete,
       eventinsert,
       remarks
from syscat.triggers
where tabschema = :schema_name

---- ListTriggerSources ----
select
       trim(trigschema) as trigschema,
       trigname,
       tabname,
       text
from syscat.triggers
where tabschema = :schema_name

---- ListViewSources ----
select
       viewname,
       text
from syscat.views
where viewschema = :schema_name

---- ListModules ----
select
       moduleid,
       trim(modulename) as modulename,
       moduletype,
       trim(base_moduleschema) as base_moduleschema,
       trim(base_modulename) as base_modulename,
       remarks
from syscat.modules
where moduleschema = :schema_name

---- ListVariables ----
select
       varid,
       trim(varname) as varname,
       varmoduleid,
       published,
       trim(typeschema) as typeschema,
       trim(typemodulename) as typemodulename,
       trim(typename) as typename,
       length,
       scale,
       codepage,
       default,
       readonly,
       remarks
from syscat.variables
where varschema = :schema_name
order by varmoduleid

---- ListConditions ----
select
       c.condid,
       trim(c.condname) as condname,
       c.condmoduleid,
       c.sqlstate,
       case
              when m.published is null then 'N'
              else m.published
       end as published
from syscat.conditions c
  left join syscat.moduleobjects m on m.objectmodulename = c.condmodulename and m.objectname = c.condname
where c.condschema = :schema_name
order by condmoduleid

---- ListRoutines ----
select
       routineid,
       trim(routinename) as routinename,
       specificname,
       routinemoduleid,
       published,
       routinetype,
       trim(return_typeschema) as return_typeschema,
       trim(return_typemodule) as return_typemodule,
       trim(return_typename) as return_typename,
       origin,
       trim(language) as language,
       result_sets,
       deterministic,
       external_action,
       sql_data_access,
       nullcall,
       trim(parameter_style) as parameter_style,
       fenced,
       threadsafe,
       dbinfo,
       newsavepointlevel,
       implementation,
       commit_on_return,
       autonomous,
       programtype,
       jar_id,
       jarschema,
       class,
       scratchpad_length,
       finalcall,
       parallel,
       secure,
       remarks
from syscat.routines
where routineschema = :schema_name and routinetype in ('F', 'P')
order by routinemoduleid

---- ListMethods ----
select
       routineid,
       trim(routinename) as routinename,
       specificname,
       trim(return_typeschema) as return_typeschema,
       trim(return_typemodule) as return_typemodule,
       trim(return_typename) as return_typename,
       trim(subject_typeschema) as subject_typeschema,
       trim(subject_typename) as subject_typename,
       overridden_methodid,
       scratchpad_length,
       finalcall,
       parallel,
       origin,
       trim(language) as language,
       result_sets,
       deterministic,
       external_action,
       sql_data_access,
       nullcall,
       trim(parameter_style) as parameter_style,
       fenced,
       threadsafe,
       dbinfo,
       remarks
from syscat.routines
where routineschema = :schema_name and routinetype = 'M'

---- ListRoutineParameters ----
select
       routinemoduleid,
       specificname,
       parmname,
       rowtype,
       ordinal,
       trim(typeschema) as typeschema,
       trim(typemodulename) as typemodulename,
       typename,
       length,
       scale,
       codepage,
       default,
       locator
from syscat.routineparms
where routineschema = :schema_name
order by routinemoduleid, specificname, ordinal

---- ListRoutineSources ----
select
       routinemoduleid,
       routineid,
       text
from syscat.routines
where routineschema = :schema_name
order by routinemoduleid

---- ListTypes ----
select
       typeid,
       trim(typename) as typename,
       typemoduleid,
       published,
       metatype,
       instantiable,
       final,
       with_func_access,
       trim(sourceschema) as sourceschema,
       trim(sourcemodulename) as sourcemodulename,
       trim(sourcename) as sourcename,
       length,
       scale,
       codepage,
       array_length,
       trim(arrayindextypeschema) as arrayindextypeschema,
       trim(arrayindextypename) as arrayindextypename,
       arrayindextypelength,
       remarks
from syscat.datatypes
where typeschema = :schema_name
order by typemoduleid

---- ListTypeAttributes ----
select
       trim(typemodulename) as typemodulename,
       typename,
       attr_name,
       ordinal,
       trim(attr_typeschema) as attr_typeschema,
       trim(attr_typemodulename) as attr_typemodulename,
       attr_typename,
       trim(target_typeschema) as target_typeschema,
       trim(target_typemodulename) as target_typemodulename,
       target_typename,
       length,
       scale,
       codepage
from syscat.attributes
where typeschema = :schema_name and
    source_typeschema = typeschema and
    coalesce(source_typemodulename, '') = coalesce(typemodulename, '') and
    coalesce(source_typemodulename, '') = coalesce(typemodulename, '') and
    source_typename = typename
union
select
       trim(typemodulename) as typemodulename,
       typename,
       fieldname,
       ordinal,
       trim(fieldtypeschema) as attr_typeschema,
       trim(fieldtypemodulename) as attr_typemodulename,
       fieldtypename as attr_typename,
       null as target_typeschema,
       null as target_typemodulename,
       null as target_typename,
       length,
       scale,
       codepage
from syscat.rowfields
where typeschema = :schema_name
order by typemodulename, typename

---- ListTypeDependencies ----
select
       typemoduleid,
       trim(typename) as typename,
       trim(bschema) as bschema,
       trim(bmodulename) as bmodulename,
       trim(bname) as bname
from syscat.datatypedep
where typeschema = :schema_name and btype = 'R'
order by typemoduleid

---- ListSequences ----
select
       seqid,
       trim(seqname) as seqname,
       seqtype,
       trim(base_seqschema) as base_seqschema,
       trim(base_seqname) as base_seqname,
       increment,
       start,
       maxvalue,
       minvalue,
       cache,
       cycle,
       order,
       precision,
       trim(d.typeschema) as typeschema,
       trim(d.typemodulename) as typemodulename,
       trim(d.typename) as typename,
       trim(case
         when d.metatype = 'T' then dd.typename
         else d.typename
       end) as actual_typename,
       d.metatype,
       s.remarks
from syscat.sequences s
  left join syscat.datatypes d on d.typeid = s.datatypeid
  left join syscat.datatypes dd on dd.typeid = d.sourcetypeid
where seqschema = :schema_name

---- ListHierarchies ----
select
       trim(sub_name) as sub_name,
       trim(super_schema) as super_schema,
       trim(super_name) as super_name
from syscat.hierarchies
where sub_schema = :schema_name and metatype = 'R'

---- ListUsers ----
select trim(authid) from sysibmadm.authorizationids where authidtype = 'U' 