/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.persistence.util;

import com.intellij.openapi.util.Condition;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.*;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author Gregory.Shrago
 */
public interface PersistenceModelBrowser {
  @NotNull
  PersistenceModelBrowser setRoleFilter(final Condition<? super PersistenceClassRole> filter);

  boolean acceptsRole(final PersistenceClassRole role);

  @NotNull
  Query<PersistentObject> queryPersistentObjectHierarchy(final PersistentObject obj);

  @NotNull
  Query<PersistentAttribute> queryAttributes(final PersistentObject obj);

  @NotNull
  Query<PersistentObject> queryTargetPersistentObjects(final PersistentRelationshipAttribute attribute);

  @NotNull
  Query<PersistentObject> queryTargetPersistentObjects(final PersistentEmbeddedAttribute attribute);

  @NotNull
  Query<PersistenceListener> queryPersistenceListeners(final PsiClass psiClass);

  @NotNull
  Query<PersistentObject> queryPersistentObjects(final PsiClass psiClass);

  @NotNull
  Query<PersistentObject> queryPersistentObjects(final PsiClass psiClass, final PersistenceClassRoleEnum type);

  @NotNull
  Query<PersistentRelationshipAttribute> queryTheOtherSideAttributes(final PersistentRelationshipAttribute relationAttribute, boolean inverseOnly);

  @NotNull
  Query<PersistentRelationshipAttribute> queryTheOtherSideAttributes(final PersistentRelationshipAttribute relationAttribute, boolean inverseOnly, final PersistentObject targetEntity);

  @NotNull
  Query<PersistenceFacet> queryPersistenceFacets(final PsiElement element);

  @NotNull
  List<PersistentAttribute> getPersistenceAttributes(final PsiMember psiMember);

  @NotNull
  List<PersistentAttribute> getPersistenceAttributes(final PersistentObject object, final PsiMember psiMember);

  @NotNull
  List<PersistenceFacet> getPersistenceFacets(final PersistencePackage unit);

  @NotNull
  List<PersistencePackage> getPersistenceUnits(final PersistenceMappings mappings);

}
