/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.persistence.model.manipulators;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.model.validators.ModelValidator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author Gregory.Shrago
 */
public interface UserResponse {
  @Nullable
  String getPersistenceUnitName(@NotNull final PersistenceFacet facet);

  VirtualFile @NotNull [] getPersistenceMappingFiles(@NotNull final PersistenceFacet facet, final String templateName, final Class<? extends PersistenceMappings> mappingsClass);

  @Nullable
  Pair<PsiDirectory, String> getClassName(@NotNull final Module module, final String title, final String helpID);

  void askUserToSetupListener(final PersistenceAction action, final PersistenceFacet facet,
                              final PsiClass aClass);

  @Nullable
  AttributeInfo getAttributeName(PersistentObject manipulatorTarget,
                        PersistentAttributeType attributeType,
                        RelationshipType relationshipType,
                        ModelValidator modelValidator, String message, String defaultName);


  class AttributeInfo {
    public final String name;
    public final PsiType type;
    public final boolean fieldAccess;
    public final boolean generated;

    public final String targetAttribute;
    public final boolean inverse;

    public AttributeInfo(final String name, final PsiType type, final boolean fieldAccess, final boolean generated) {
      this.name = name;
      this.type = type;
      this.fieldAccess = fieldAccess;
      this.generated = generated;
      targetAttribute = null;
      inverse = false;
    }

    public AttributeInfo(final String name, final PsiType type,
                         final boolean fieldAccess,
                         final String targetAttribute, final boolean inverse) {
      this.name = name;
      this.type = type;
      this.generated = false;
      this.fieldAccess = fieldAccess;
      this.targetAttribute = targetAttribute;
      this.inverse = inverse;
    }
  }
}
