/*
 * Copyright 2000-2009 JetBrains s.r.o.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package com.intellij.persistence.model;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;

/**
 * @author Gregory.Shrago
 */
public interface PersistentAttributeType {
  @NotNull
  String getTypeName();

  @Nullable
  RelationshipType getRelationshipType();

  Icon getIcon();

  enum ComponentType { BASIC, EMBEDDABLE, ENTITY, ANY }
  enum AttributeComponent { SINGLE, COLLECTION_VALUE, COLLECTION_VALUE_KEY }

  boolean accepts(final AttributeComponent component, final ComponentType targetType);
  boolean isIdAttribute();
  boolean isVersionAttribute();
}
