/*
 * Copyright (c) 2000-2006 JetBrains s.r.o. All Rights Reserved.
 */

package com.intellij.persistence.model;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.persistence.facet.PersistenceFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PersistencePackagePointer {
  @NlsSafe String getElementName();

  @Nullable
  PersistencePackage findElement();

  PersistenceFacet getPersistenceFacet();

  @NotNull
  FacetPointer<? extends Facet> getFacetPointer();
}
