/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.persistence;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.persistence.model.manipulators.ManipulatorsRegistry;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;

/**
 * @author Gregory.Shrago
 */
public abstract class PersistenceHelper {

  public static PersistenceHelper getHelper() {
    return ApplicationManager.getApplication().getService(PersistenceHelper.class);
  }

  @NotNull
  public abstract ManipulatorsRegistry getManipulatorsRegistry();

  @NotNull
  public abstract PersistenceModelBrowser createModelBrowser();

  public abstract PersistenceModelBrowser getSharedModelBrowser();

  public abstract void runCompositeWriteCommandAction(@NotNull Project project,
                                                      @NotNull String actionName,
                                                      @NotNull Collection<PsiElement> affectedElements,
                                                      @NotNull Ref<ProgressIndicator> indicatorRef,
                                                      Runnable @NotNull ... actions);
}
