/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.persistence;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentObject;

/**
 * @author Gregory.Shrago
 */
public final class PersistenceDataKeys {

  private PersistenceDataKeys() {
  }
  public static final DataKey<PersistenceFacet> PERSISTENCE_FACET_CONTEXT = DataKey.create("PERSISTENCE_FACET_CONTEXT");
  public static final DataKey<PersistenceFacet> PERSISTENCE_FACET = DataKey.create("PERSISTENCE_FACET");

  public static final DataKey<PersistencePackage> PERSISTENCE_UNIT = DataKey.create("PERSISTENCE_UNIT");
  public static final DataKey<PersistencePackage> PERSISTENCE_UNIT_CONTEXT = DataKey.create("PERSISTENCE_UNIT_CONTEXT");

  public static final DataKey<PersistentObject> PERSISTENT_OBJECT = DataKey.create("PERSISTENT_OBJECT");
  public static final DataKey<PersistentObject> PERSISTENT_OBJECT_CONTEXT = DataKey.create("PERSISTENT_OBJECT");

  public static final DataKey<CommonModelElement> MODEL_ELEMENT_CONTEXT = DataKey.create("MODEL_ELEMENT_CONTEXT");
}
