/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.web;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author spleaner
 */
public class WebLogicalRoot extends LogicalRoot {
  public static final LogicalRootType<WebLogicalRoot> WEB_ROOT_TYPE = LogicalRootType.create("Web root");

  private final WebRoot myWebRoot;

  public WebLogicalRoot(final WebRoot webRoot) {
    myWebRoot = webRoot;
    assert myWebRoot.getFile() != null;
  }

  public WebRoot getWebRoot() {
    return myWebRoot;
  }

  @Override
  @Nullable
  public VirtualFile getVirtualFile() {
    return myWebRoot.getFile();
  }

  @Override
  @NotNull
  public LogicalRootType getType() {
    return WEB_ROOT_TYPE;
  }
}
