package com.intellij.javaee.utils.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javaee.J2EEBundle;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiUtil;

public class JavaeeHighlightingUtil {
  public static void checkClassIsInterface(ProblemsHolder holder, PsiClass aClass, boolean shouldBe) {
    if (shouldBe != aClass.isInterface()) {
      holder.registerProblem(aClass, getClassDeclarationRange(aClass),
                             J2EEBundle.message(shouldBe ? "should.be.interface" : "should.not.be.interface", aClass.getName()),
                             QuickFixFactory.getInstance().createMakeClassInterfaceFix(aClass, shouldBe));
    }
  }

  public static TextRange getClassDeclarationRange(final PsiClass aClass) {
    return HighlightNamesUtil.getClassDeclarationTextRange(aClass).shiftRight(-aClass.getTextRange().getStartOffset());
  }

  public static void checkClassModifier(ProblemsHolder holder,
                                        PsiClass aClass,
                                        @PsiModifier.ModifierConstant String modifier,
                                        boolean shouldHave) {
    PsiModifierList modifierList = aClass.getModifierList();
    if (modifierList != null && modifierList.hasModifierProperty(modifier) != shouldHave) {
      final PsiElement keyword = PsiUtil.findModifierInList(modifierList, modifier);
      if (keyword != null) {
        holder.registerProblem(keyword, getClassShouldMessage(aClass.isInterface(), shouldHave, aClass.getName(), modifier),
                               QuickFixFactory.getInstance().createModifierListFix(aClass, modifier, shouldHave, false));
      }
      else {
        holder.registerProblem(aClass, getClassDeclarationRange(aClass), getClassShouldMessage(aClass.isInterface(), shouldHave, aClass.getName(), modifier),
                               QuickFixFactory.getInstance().createModifierListFix(aClass, modifier, shouldHave, false));
      }
    }
  }

  @InspectionMessage
  private static String getClassShouldMessage(boolean anInterface, boolean shouldHave, String className, String modifier) {
    if (anInterface) {
      return J2EEBundle.message(shouldHave ? "interface.should.have.modifier" : "interface.should.not.have.modifier", className, modifier);
    }
    return J2EEBundle.message(shouldHave ? "class.should.have.modifier" : "class.should.not.have.modifier", className, modifier);
  }
}
