/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated on Tue Feb 14 17:35:31 MSK 2006
// DTD/Schema  :    http://java.sun.com/xml/ns/javaee

package com.intellij.javaee.model.xml.web;

import com.intellij.javaee.constants.JavaeeCommonConstants;
import com.intellij.javaee.ejb.model.common.JndiEnvironmentRefsGroup;
import com.intellij.javaee.ejb.model.common.ServiceRefGroup;
import com.intellij.javaee.model.xml.*;
import com.intellij.util.xml.*;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * http://java.sun.com/xml/ns/javaee:web-appType interface.
 */
@Namespace(JavaeeCommonConstants.WEB_NAMESPACE_KEY)
@Stubbed
public interface WebApp extends JavaeeDomModelElement, DescriptionGroup, JndiEnvironmentRefsGroup, ServiceRefGroup {
  @NotNull
  @Stubbed
  GenericAttributeValue<WebAppVersion> getVersion();

  GenericAttributeValue<Boolean> getMetadataComplete();

  @SubTag(value = "distributable", indicator = true)
  GenericDomValue<Boolean> getDistributable();

  @Stubbed
  List<ParamValue> getContextParams();
  ParamValue addContextParam();

  @Stubbed
  List<Filter> getFilters();
  Filter addFilter();

  List<FilterMapping> getFilterMappings();
  FilterMapping addFilterMapping();

  @Stubbed
  List<Listener> getListeners();
  Listener addListener();

  @Stubbed
  List<Servlet> getServlets();
  Servlet addServlet();

  @Stubbed
  List<ServletMapping> getServletMappings();
  ServletMapping addServletMapping();

  List<SessionConfig> getSessionConfigs();

  List<MimeMapping> getMimeMappings();

  List<WelcomeFileList> getWelcomeFileLists();

  List<ErrorPage> getErrorPages();

  @Stubbed
  List<JspConfig> getJspConfigs();

  JspConfig addJspConfig();

  List<SecurityConstraint> getSecurityConstraints();

  List<LoginConfig> getLoginConfigs();

  @Stubbed
  List<SecurityRole> getSecurityRoles();

  List<MessageDestination> getMessageDestinations();

  List<LocaleEncodingMappingList> getLocaleEncodingMappingLists();
}
