/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package com.intellij.javaee.model.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.javaee.model.CommonListener;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

/**
 * @author peter
 */
public abstract class JamListener extends CommonModelElement.PsiBase implements CommonListener, JamElement {
  public static final JamClassMeta<JamListener> LISTENER_CLASS_META = new JamClassMeta<>(JamListener.class);

  @Override
  @JamPsiConnector
  public abstract PsiClass getPsiClass();


  @Override
  @JamPsiValidity
  public abstract boolean isValid();


  @NotNull
  @Override
  public PsiElement getPsiElement() {
    return getPsiClass();
  }

}
